/*
 * Decompiled with CFR 0.152.
 */
package org.scalameter.execution.invocation.instrumentation;

import java.util.concurrent.atomic.AtomicLongArray;

public class MethodInvocationCounter {
    private static volatile State state = State.UNINITIALIZED;
    private static AtomicLongArray rawCounts;

    public static synchronized void setup(int n) {
        rawCounts = new AtomicLongArray(n);
        state = State.INITIALIZED;
    }

    public static synchronized void start() {
        if (state == State.INITIALIZED || state == State.STOPPED) {
            state = State.STARTED;
        }
    }

    public static synchronized void stop() {
        if (state == State.STARTED) {
            state = State.STOPPED;
        }
    }

    public static void methodCalled(int n) {
        if (state == State.STARTED) {
            rawCounts.incrementAndGet(n);
        }
    }

    public static long[] counts() {
        if (state == State.STOPPED) {
            long[] lArray = new long[rawCounts.length()];
            for (int i = 0; i < rawCounts.length(); ++i) {
                lArray[i] = rawCounts.get(i);
            }
            return lArray;
        }
        throw new RuntimeException("counts() can be called only after call to the stop() method");
    }

    private static enum State {
        UNINITIALIZED,
        INITIALIZED,
        STARTED,
        STOPPED;

    }
}

